using System;

public class ComplexNumber
{
    private double real,imaginary;
   

    public double Real
    {
        get { return real; }
    }

    public double Imaginary
    {
        get { return imaginary; }
    }
           
    public ComplexNumber(double a, double b)
    {
        real = a; imaginary = b;
    }

    public override string ToString()
    {
        return string.Format("({0} {1} {2}i)", real, (imaginary <0 ? "-" : "+"), Math.Abs(imaginary));
    }

    public static ComplexNumber operator +(ComplexNumber z1, ComplexNumber z2)
    {
        return new ComplexNumber(z1.real + z2.real, z1.imaginary + z2.imaginary);
    }

    public static ComplexNumber operator *(ComplexNumber z1, ComplexNumber z2)
    {
        return new ComplexNumber(z1.real * z2.real - z1.imaginary * z2.imaginary,
                                 z1.real * z2.imaginary + z2.real * z1.imaginary);
    }

}
